<?php



class UserInterest extends AppModel
{
    public $useTable = 'user_interest';

    public $belongsTo = array(

        'Interest' => array(
            'className' => 'Interest',
            'foreignKey' => 'interest_id',


        ),
        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
            //'fields' => array('User.id','User.email','User.username','User.image','User.device_token')

        ),

    );

    public function getDetails($id)
    {
        return $this->find('first', array(
            'conditions' => array(

                'UserInterest.id' => $id





            )
        ));
    }


    public function getAll()
    {
        return $this->find('all', array(
            'contain' => array(
                'Interest' => array(

                    'order' => 'UserInterest.order ASC',

                )
            ),
            'order' => 'InterestSection.order ASC'
        ));

    }

    public function ifExist($user_id,$interest_id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'UserInterest.user_id'=> $user_id,
                'UserInterest.interest_id'=> $interest_id,




            )
        ));
    }

    public function getAllAgainstUser($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'UserInterest.user_id'=> $user_id,





            ),
            'contain' => array('Interest'),
        ));
    }

    public function deleteAllInterests($user_id){


        $this->deleteAll(
            [
                'UserInterest.user_id' => $user_id,

            ],
            false # <- single delete statement please
        );
    }




}