<?php


class Document extends AppModel
{
    public $useTable = 'document';

    public $belongsTo = array(
        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
            //'fields' => array('User.id','User.email','User.username','User.image','User.device_token')

        ),


    );


    public function getDetails($id)
    {

        return $this->find('first', array(
            'conditions' => array('Document.id' => $id)
        ));

    }


    public function checkDocumentExistAgainstUserID($user_id)
    {

        return $this->find('all', array(
            'conditions' => array(
                'Document.user_id' => $user_id,

                )
        ));

    }

    public function getDocument($user_id)
    {

        return $this->find('all', array(
            'conditions' => array('Document.user_id' => $user_id),
            'recursive'=>-1
        ));

    }



    public function getDocumentAgainstType($user_id,$type)
    {

        return $this->find('first', array(
            'conditions' => array(
                'Document.user_id' => $user_id,
                'Document.type' => $type,
                'Document.status' => array(0,1),

            ),
            'recursive'=>-1
        ));

    }







    public function getAll()
    {

        return $this->find('all');

    }





}

?>